
### PEW Religiosity Survey - Plot Alcohol Immoral ###

library(readstata13)
library(ggplot2)
library(tidyverse)
library(car)


pew <- read.dta13("2012-Pew-Religion-Worlds-Muslims_dataset.dta")

pew$moral <- ifelse(pew$Q84d == 2, 1,
                    ifelse(pew$Q84d == 1, 0, NA))

pew$moral <- ifelse(pew$COUNTRY== 21 | pew$COUNTRY== 23 | pew$COUNTRY== 6 |
                      pew$COUNTRY== 17 | pew$COUNTRY== 26, NA, pew$moral)
pew <- subset(pew, !is.na(moral))
table(pew$moral)

pew$cty = recode(pew$COUNTRY,"1='Afghanistan'; 2='Albania'; 3='Algeria'; 4='Azerbaijan'; 
                 5='Bangladesh'; 7='Egypt'; 8='Indonesia'; 9='Iran'; 
                 10='Iraq'; 11='Jordan'; 12='Kazakhstan'; 13='Kosovo'; 
                 14='Kyrgyzstan'; 15='Lebanon'; 16='Malaysia'; 18='Niger'; 
                 19='Pakistan'; 20='Palestine'; 22='Tajikistan'; 24='Tunisia'; 
                 25='Turkey'")


pew_moral <- pew %>%
  group_by(cty) %>%
  summarize(avg_moral = mean(moral))


### Plot

# Alphabetical
ggplot(data=pew_moral,
       aes(x=cty, y=avg_moral)) + 
  geom_bar(stat="identity", fill="grey60") + 
  geom_bar(data=pew_moral[pew_moral$cty=="Indonesia",], stat="identity") +
  geom_bar(data=pew_moral[pew_moral$cty=="Tunisia",], stat="identity") +
  geom_text(aes(label = round(avg_moral, 2)), hjust = -0.2, size = 4, color = "black") +
  scale_y_continuous(limits=c(0,1.05), breaks=c(0, 0.2, 0.4, 0.6, 0.8, 1)) +
  scale_x_discrete(limits=rev) +
  labs(x = "", y = "",
       title = "Proportion of Respondents \n Who Believe that Drinking Alcohol is Morally Wrong") +
  theme_bw() + 
  theme(plot.title = element_text(hjust = 0.5)) +
  theme(axis.text=element_text(size=14),
        plot.title = element_text(size=14)) + 
  coord_flip()
  

# ordered
plot.alc.moral.ord <- ggplot(data=pew_moral,
                             aes(x=reorder(cty, -avg_moral), y=avg_moral)) + 
  geom_bar(stat="identity", fill="grey60") + 
  geom_bar(data=pew_moral[pew_moral$cty=="Indonesia",], stat="identity") +
  geom_bar(data=pew_moral[pew_moral$cty=="Tunisia",], stat="identity") +
  geom_text(aes(label = round(avg_moral, 2)), hjust = -0.2, size = 4, color = "black") +
  scale_y_continuous(limits=c(0,1.05), breaks=c(0, 0.2, 0.4, 0.6, 0.8, 1)) +
  scale_x_discrete(limits=rev) +
  labs(x = "", y = "",
       title = "Proportion of Respondents \n Who Believe that Drinking Alcohol is Morally Wrong") +
  theme_bw() + 
  theme(plot.title = element_text(hjust = 0.5)) +
  theme(axis.text=element_text(size=14),
        plot.title = element_text(size=14)) + 
  coord_flip()

png("Figure 1a.png", width=2000, height=2500, res=300)
plot.alc.moral.ord
dev.off()

